<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;

class ObscureContactsOnly
{
    public function handle(Request $request, Closure $next)
{
    // Only GET
    if ($request->method() !== 'GET') {
        return $next($request);
    }

    // Skip AJAX / XHR / JSON requests
    if ($request->ajax() || $request->expectsJson() ||
        str_starts_with($request->header('Accept', ''), 'application/json')) {
        return $next($request);
    }

    $path = ltrim($request->path(), '/');

    if ($path === 'contacts' || str_starts_with($path, 'contacts/')) {
        // If already /contacts/{RANDOM}, pass through
        if (preg_match('#^contacts/[A-Za-z0-9]{16,128}$#', $path)) {
            return $next($request);
        }

        $length = (int) config('app.obscure_slug_length', 40);
        $ttl    = (int) config('app.obscure_slug_ttl', 10);
        $slug   = \Illuminate\Support\Str::random($length);

        $original = '/' . $path;
        if ($qs = $request->getQueryString()) {
            $original .= '?' . $qs;
        }

        \Illuminate\Support\Facades\Cache::put("slug_map_contacts:{$slug}", $original, now()->addMinutes($ttl));

        return redirect('/contacts/' . $slug, 302);
    }

    return $next($request);
}

    public function handle(Request $request, Closure $next)
    {
        // Only GET page loads
        if ($request->method() !== 'GET') {
            return $next($request);
        }

        $path = ltrim($request->path(), '/');

        // Only act on /contacts and /contacts/* (Laravel routes; the /test prefix is webserver-level)
        if ($path === 'contacts' || str_starts_with($path, 'contacts/')) {

            // If it's already a long random slug like /contacts/{slug}, let it pass
            if (preg_match('#^contacts/[A-Za-z0-9]{16,128}$#', $path)) {
                return $next($request);
            }

            // Map original URL to a slug and redirect to /contacts/{slug}
            $length = (int) config('app.obscure_slug_length', 40);
            $ttl    = (int) config('app.obscure_slug_ttl', 10); // minutes
            $slug   = Str::random($length);

            $original = '/' . $path;
            if ($qs = $request->getQueryString()) {
                $original .= '?' . $qs;
            }

            Cache::put("slug_map_contacts:{$slug}", $original, now()->addMinutes($ttl));

            return redirect('/contacts/' . $slug, 302);
        }

        return $next($request);
    }
}
